SET QUOTED_IDENTIFIER ON
GO

IF EXISTS
  (SELECT *
     FROM [dbo].[KYScriptLog] SKL
    WHERE SKL.[MajorVersion] = 5
      AND SKL.[MinorVersion] = 1
      AND SKL.[Build] = 1
      AND SKL.[Revision] = 155
      AND SKL.[COMMENT] = '006 SQL Data Pump.SQL')
BEGIN
  SET NOCOUNT ON
  SET NOEXEC ON
END
GO

INSERT
  INTO [dbo].[KYScriptLog]
      ([timestamp],
       [MajorVersion],
       [MinorVersion],
       [Build],
       [Revision],
       [CompatibleVersion],
       [COMMENT])
VALUES(GetDate(),
       5,
       1,
       1,
       155,
       'Build 5.1.1.155',
       '006 SQL Data Pump.SQL')
GO

/* SQL Data Pump */

/************************
ActionFlag Default Value
17June2014
*************************/

IF NOT EXISTS(SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID = 0  )
BEGIN
	INSERT INTO ActionFlag VALUES('0','Clear Flag',1)
END

	
GO
IF NOT EXISTS(SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID = 1 )
BEGIN
	INSERT INTO ActionFlag VALUES('1','Blue Flag',1)
END

	
GO

IF NOT EXISTS(SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID = 2 )
BEGIN
	INSERT INTO ActionFlag VALUES('2','Orange Flag',1)
END

	
GO

IF NOT EXISTS(SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID = 3 )
BEGIN
	INSERT INTO ActionFlag VALUES('3','Red Flag',1)
END
	
GO

IF NOT EXISTS(SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID = 4 )
BEGIN
	INSERT INTO ActionFlag VALUES('4','Green Flag',1)
END

	
GO

IF NOT EXISTS(SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID = 5 )
BEGIN
	INSERT INTO ActionFlag VALUES('5','Black Flag',1)
END

	
GO

IF NOT EXISTS(SELECT TOP 1 1 FROM ActionFlag WHERE ActionFlagID = 6 )
BEGIN
	INSERT INTO ActionFlag VALUES('6','Yellow Flag',1)
END

GO

/********************************
Email Settings 
18June2014
**********************************/

IF NOT EXISTS(SELECT 1 FROM Settings WHERE KeyName = 'EMailServer')
BEGIN
	INSERT INTO Settings(KeyName, KeyValue) VALUES ('EMailServer', '')
END

GO

IF NOT EXISTS(SELECT 1 FROM Settings WHERE KeyName = 'EmailServerPort')
BEGIN
	INSERT INTO Settings(KeyName, KeyValue) VALUES ('EmailServerPort', '2525')
END

GO

IF NOT EXISTS(SELECT 1 FROM Settings WHERE KeyName = 'EmailIsAnonymous')
BEGIN
	INSERT INTO Settings(KeyName, KeyValue) VALUES ('EmailIsAnonymous', 'True')
END

GO

IF NOT EXISTS(SELECT 1 FROM Settings WHERE KeyName = 'EmailUserName')
BEGIN
	INSERT INTO Settings(KeyName, KeyValue) VALUES ('EmailUserName', '')
END

GO

IF NOT EXISTS(SELECT 1 FROM Settings WHERE KeyName = 'EmailPassword')
BEGIN
	INSERT INTO Settings(KeyName, KeyValue) VALUES ('EmailPassword', '')
END

GO

IF NOT EXISTS(SELECT 1 FROM Settings WHERE KeyName = 'DefaultCcMailTo')
BEGIN
	INSERT INTO Settings(KeyName, KeyValue) VALUES ('DefaultCcMailTo', '')
END

GO

IF NOT EXISTS(SELECT 1 FROM Settings WHERE KeyName = 'DefaultBccMailTo')
BEGIN
	INSERT INTO Settings(KeyName, KeyValue) VALUES ('DefaultBccMailTo', '')
END

GO

--EstFeeWarningLimit
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName = 'EstFeeWarningLimit')
BEGIN
	Insert into Settings (KeyName, KeyValue ) VALUES ('EstFeeWarningLimit','80')
END

GO
--Debtor Days Over
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='DebtorWarningDaysLimit')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('DebtorWarningDaysLimit','60')
END

GO
--LastActionMonth
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='LastActionMonth')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('LastActionMonth','6')
END

GO

--LockupUpValue
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='LockupUpValue')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('LockupUpValue','20000')
END


GO
--Show Alarm
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='ShowAlarm')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('ShowAlarm','True')
END

GO
--Estimate Fee required at matter setup
IF NOT EXISTS(SELECT TOP 1 1 FROM Settings WHERE KeyName='EstFeeRequiredatMatterSetup')
BEGIN
	INSERT INTO Settings (KeyName, KeyValue ) VALUES ('EstFeeRequiredatMatterSetup','True')
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[IManage])
BEGIN
  INSERT
    INTO [dbo].[IManage]
        ([ACTIVE])
  VALUES(0)
END
GO


IF NOT EXISTS (SELECT TOP 1 1 FROM Settings WHERE KeyName = 'TimeDayBookLimit')
	INSERT INTO Settings (KeyName,KeyValue ) VALUES ('TimeDayBookLimit',0)

GO
	
IF NOT EXISTS (SELECT TOP 1 1 FROM Settings WHERE KeyName = 'OSInvoiceLimit')
	INSERT INTO Settings (KeyName,KeyValue ) VALUES ('OSInvoiceLimit',0)
GO
	
IF NOT EXISTS (SELECT TOP 1 1 FROM Settings WHERE KeyName = 'CurrentWIPLimit')
	INSERT INTO Settings (KeyName,KeyValue ) VALUES ('CurrentWIPLimit',0)
GO
	
IF NOT EXISTS (SELECT TOP 1 1 FROM Settings WHERE KeyName = 'DraftInvoiceLimit')
	INSERT INTO Settings (KeyName,KeyValue ) VALUES ('DraftInvoiceLimit',0)

GO

/*
Praveen 21NOV2014
	In the new system StopwatchStatus column has been used to highlight the current running timer in Mydaybook form
but the values in the database entered by the old sysyem in inefficient and so to reset the old entries created by existing system 
the below script will be used 
 */
IF EXISTS
  (SELECT TOP 1 1 
     FROM SYS.[objects] SO
          INNER JOIN [sys].[columns] SC
                  ON SC.[object_id] = SO.[object_id]
                 AND SC.[name] = 'StopwatchStatus'
                 AND SC.[precision] < 9
    WHERE SO.[name] = 'TimeDayBook'
      AND SO.[type] = 'U')
BEGIN
	UPDATE  
		TimeDayBook 
	SET
		StopwatchStatus=1
END
GO

IF NOT EXISTS
  (SELECT *
     FROM [dbo].[CRReport] CRR
    WHERE CRR.[report_type] = 'B')
  BEGIN
    IF EXISTS
      (SELECT *
         FROM [dbo].[CRReport] CRR
        WHERE CRR.[name] = 'Bill Layout')
      BEGIN
        UPDATE CRR
           SET CRR.[report_type] = 'B'
          FROM [dbo].[CRReport] CRR
         WHERE CRR.[name] = 'Bill Layout'
      END
  END
GO

UPDATE SKL
   SET SKL.[COMMENT] = '006 SQL Data Pump.SQL' 
  FROM [dbo].[KYScriptLog] SKL
 WHERE SKL.[MajorVersion] = 5
   AND SKL.[MinorVersion] = 1
   AND SKL.[Build] = 1
   AND SKL.[Revision] = 155
   AND SKL.[COMMENT] = '006 SQL Data Pump.SQL **FAILED**'
GO

SET NOEXEC OFF
SET NOCOUNT OFF
GO
